<?php

namespace App\Http\Controllers;

use Illuminate\Support\Str;
use Carbon\Carbon;
use App\Models\QrCode as QrCodeModel;
use SimpleSoftwareIO\QrCode\Facades\QrCode as QrGenerator;

class QrCodeController extends Controller
{
    public function index()
    {
        $url = "https://example.com";

        return response(
            QrGenerator::format('svg')
                ->size(300)
                ->generate($url),
            200
        )->header('Content-Type', 'image/svg+xml');
    }

    // Générer un QR valable 72h
    public function generate()
    {
        $token = Str::uuid()->toString();

        $qr = QrCodeModel::create([
            'token' => $token,
            'expires_at' => Carbon::now()->addHours(72),
        ]);

        $url = route('qr.check', $token);

        return response(
            QrGenerator::format('svg')
                ->size(300)
                ->generate($url),
            200
        )->header('Content-Type', 'image/svg+xml');
    }

    // Vérifier le QR
    public function check($token)
    {
        $qr = QrCodeModel::where('token', $token)->first();

        if (!$qr) {
            return response("QR Code invalide", 404);
        }

        if (Carbon::now()->greaterThan($qr->expires_at)) {
            return response("QR Code expiré", 403);
        }

        return "QR Code valide ✅";
    }
}
